SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Historic]') AND name = N'IxHisRespondent')
DROP INDEX [IxHisRespondent] ON [dbo].[Historic] WITH ( ONLINE = OFF )
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Response]') AND name = N'IxRpsQuestionContent')
DROP INDEX [IxRpsQuestionContent] ON [dbo].[Response] WITH ( ONLINE = OFF )
GO

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[TimeSlotHit]') AND name = N'IxTshRespondent')
DROP INDEX [IxTshRespondent] ON [dbo].[TimeSlotHit] WITH ( ONLINE = OFF )
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Sp_respondentconnectquotas]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[Sp_respondentconnectquotas]
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Sp_respondentconnectquotas]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[Sp_respondentconnectquotas]
                @ProjectId  INT,
                @Respondent VARCHAR(10),
                @Action     INT
AS
  IF (@Action = 1)
  BEGIN
    UPDATE Quota
    SET    QtOnline = QtOnline + 1
    WHERE  EXISTS (SELECT 1 FROM Stratum WHERE StrRespondent = @Respondent and StrQuotaId = QtQuotaId)
  END
  ELSE IF (@Action = 2)
  BEGIN
    UPDATE Quota
    SET    QtOnline = QtOnline - 1
    WHERE  QtOnline > 0 and EXISTS (SELECT 1 FROM Stratum WHERE StrRespondent = @Respondent and StrQuotaId = QtQuotaId)
  END
  ELSE IF (@Action = 3)
  BEGIN
    UPDATE Quota
    SET    QtOnline = 0
  END
' 
END

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Sp_respondentisinclosedstrate]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[Sp_respondentisinclosedstrate]
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Sp_respondentisinclosedstrate]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[Sp_respondentisinclosedstrate]
                @ProjectId  INT,
                @Respondent VARCHAR(10)
AS
  SELECT COUNT(*)
  FROM Stratum WITH(NOLOCK) INNER JOIN Quota WITH(NOLOCK) ON StrQuotaId = QtQuotaId
  WHERE StrRespondent = @Respondent AND QtStatus = 2
' 
END
GO

